unit Lista4u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Tetel: TEdit;
    Tetelek: TListBox;
    HozzaAd: TButton;
    Kivalaszt: TButton;
    TetelekHossza: TListBox;
    Torles: TButton;
    Kilepes: TButton;
    procedure TorlesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure KilepesClick(Sender: TObject);
    procedure HozzaAdClick(Sender: TObject);
    procedure KivalasztClick(Sender: TObject);
    procedure TetelekClick(Sender: TObject);
    procedure TetelekHosszaClick(Sender: TObject);
  private
    procedure TetelekHosszaBeiras;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.TetelekHosszaBeiras;
var
   i, h : integer;
   buff : string[80];
begin
  // a "Ttelek hossza" listaabak tartalmnak trlse
  TetelekHossza.Clear;
  for i:=0 to Tetelek.Items.Count-1 do
  begin
    // a "Tetelek" lista ttelhossznak
    // talaktsa sztringg
    buff := IntToStr(length(Tetelek.Items[i]));
    // a "Ttelek hossza" listba rdik be a buff tartalma
    TetelekHossza.Items.Add(buff);
  end;
end;
procedure TForm1.TorlesClick(Sender: TObject);
begin
   // a "Ttelek" lista trlse
   Tetelek.Clear;
   // a "Ttelek hossza" lista trlse
   TetelekHossza.Clear;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   // a "Ttelek" lista feltltse
   Tetelek.Items.Add('alma');
   Tetelek.Items.Add('di');
   Tetelek.Items.Add('bann');
   Tetelek.Items.Add('eper');
   Tetelek.Items.Add('meggy');
   Tetelek.Items.Add('cseresznye');
   TetelekHosszaBeiras;
end;

procedure TForm1.KilepesClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.HozzaAdClick(Sender: TObject);
var
   j: integer;
begin
   // mindkt listba a kivlasztsok trlse
   for j:=1 to TetelekHossza.Items.Count-1 do
   begin
     TetelekHossza.Selected[j]:=false;
     Tetelek.Selected[j]:= false;
   end;
  // a szvegmez tartalmnak vizsglata
  if Tetel.GetTextLen > 0 then
  begin
     if Tetelek.Items.IndexOf(Tetel.Text) = -1 then
     begin
       Tetelek.Items.Add(Tetel.Text);
       // a "Ttelek hossza" lista trlse
       TetelekHosszaBeiras;
     end;
  end;
  // a szvegmez tartalmnak trlse
  Tetel.Clear;
  Tetel.SetFocus;
end;

procedure TForm1.KivalasztClick(Sender: TObject);
var
   i, j : integer;
begin
   // mindkt listban trljk a kivlasztst
   for j:=1 to TetelekHossza.Items.Count-1 do
   begin
     TetelekHossza.Selected[j]:=false;
     Tetelek.Selected[j]:= false;
   end;
   if Tetel.GetTextLen > 0 then
   begin
     i:=Tetelek.Items.IndexOf(Tetel.Text);
     if i <> -1 then
     begin
       // a keresett ttel benne van a listban
       Tetelek.Selected[i]:= true;
       TetelekHossza.Selected[i]:= true;
     end;
     Tetel.SetFocus;
   end
end;

procedure TForm1.TetelekClick(Sender: TObject);
begin
   if TetelekHossza.ItemIndex >= 0 then
     TetelekHossza.Selected[TetelekHossza.ItemIndex] := false;
   if Tetelek.ItemIndex >= 0 then
     TetelekHossza.Selected[Tetelek.ItemIndex] := true;
end;

procedure TForm1.TetelekHosszaClick(Sender: TObject);
begin
 if Tetelek.ItemIndex >= 0 then
     Tetelek.Selected[Tetelek.ItemIndex] := false;
 if TetelekHossza.ItemIndex >= 0 then
     Tetelek.Selected[TetelekHossza.ItemIndex] := true;
end;

end.
